/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.sdk.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baijiayun.duanxunbao.sdk.service.BjyPartnerService;
import com.baijiayun.duanxunbao.sdk.service.WalletService;
import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class WalletServiceImpl
implements WalletService {
    private static final Logger log = LoggerFactory.getLogger(WalletServiceImpl.class);
    @Autowired
    private BjyPartnerService bjyPartnerService;

    @Override
    public Object partnerInfoList(String partnerId, String token, List<String> partnerIds) {
        log.info("partnerInfoList partnerId: {}, token: {},  partnerIds:{}", new Object[]{partnerId, token, partnerIds});
        if (CollectionUtils.isEmpty(partnerIds)) {
            return null;
        }
        String partnerStr = Joiner.on((String)",").join(partnerIds);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("partner_ids", partnerStr);
        return this.bjyPartnerService.bjyPost("scrm/partner/list", params, null);
    }

    @Override
    public Object accountInfo(String partnerId, String token, Map<String, String> map) {
        log.info("accountInfo partnerId: {}, token: {},  map:{}", new Object[]{partnerId, token, map});
        return this.bjyPartnerService.bjyPost(partnerId, token, "scrm/account/info", map);
    }

    @Override
    public Object wxPayQrcode(String partnerId, String token, Map<String, String> map) {
        log.info("wxPayQrcode partnerId: {}, token: {},  map:{}", new Object[]{partnerId, token, map});
        return this.bjyPartnerService.bjyPost(partnerId, token, "scrm/order/wxPayQrcode", map);
    }

    @Override
    public Object getPayStatus(String partnerId, String token, Map<String, String> map) {
        log.info("getPayStatus partnerId: {}, token: {},  map:{}", new Object[]{partnerId, token, map});
        return this.bjyPartnerService.bjyPost(partnerId, token, "scrm/order/getPayStatus", map);
    }

    @Override
    public Object payOffline(String partnerId, String token, Map<String, String> map) {
        log.info("payOffline partnerId: {}, token: {},  map:{}", new Object[]{partnerId, token, map});
        return this.bjyPartnerService.bjyPost(partnerId, token, "scrm/order/payOffline", map);
    }

    @Override
    public Object consumeStatisticsByMonth(String partnerId, String token, Map<String, String> map) {
        log.info("consumeStatisticsByMonth partnerId: {}, token: {},  map:{}", new Object[]{partnerId, token, map});
        return this.bjyPartnerService.bjyPost(partnerId, token, "scrm/bill/consumeStatisticsByMonth", map);
    }

    @Override
    public Object getBankVirtualAccount(String partnerId, String token, Map<String, String> map) {
        log.info("getBankVirtualAccount partnerId: {}, token: {},  map:{}", new Object[]{partnerId, token, map});
        return this.bjyPartnerService.bjyPost(partnerId, token, "scrm/order/getBankVirtualAccount", map);
    }

    @Override
    public void exprotConsumeStatisticsByMonth(String partnerId, String token, Map<String, String> map, HttpServletResponse response) {
        log.info("exprotConsumeStatisticsByMonth partnerId: {}, token: {},  map:{}", new Object[]{partnerId, token, map});
        map.put("render", "json");
        JSONObject jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm/bill/exprotConsumeStatisticsByMonth", map);
        JSONObject data = jsonObject.getJSONObject("data");
        JSONArray list = data.getJSONArray("list");
        List dataList = (List)JSONArray.parseObject((String)list.toJSONString(), List.class);
        JSONObject header = data.getJSONObject("header");
        this.export(header, dataList, data.getString("title"), "\u6d88\u8d39\u8bb0\u5f55", response);
    }

    @Override
    public Object getRevenueList(String partnerId, String token, Map<String, String> map) {
        log.info("getRevenueList partnerId: {}, token: {},  map:{}", new Object[]{partnerId, token, map});
        return this.bjyPartnerService.bjyPost(partnerId, token, "scrm/bill/getRevenueList", map);
    }

    @Override
    public void exportRevenueList(String partnerId, String token, Map<String, String> map, HttpServletResponse response) {
        log.info("exportRevenueList partnerId: {}, token: {},  map:{}", new Object[]{partnerId, token, map});
        map.put("render", "json");
        JSONObject jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm/bill/exportRevenueList", map);
        JSONObject data = jsonObject.getJSONObject("data");
        JSONArray list = data.getJSONArray("list");
        List dataList = (List)JSONArray.parseObject((String)list.toJSONString(), List.class);
        JSONObject header = data.getJSONObject("header");
        this.export(header, dataList, data.getString("title"), "\u6536\u652f\u660e\u7ec6", response);
    }

    @Override
    public Object getBillList(String partnerId, String token, Map<String, String> map) {
        log.info("getBillList partnerId: {}, token: {},  map:{}", new Object[]{partnerId, token, map});
        return this.bjyPartnerService.bjyPost(partnerId, token, "scrm/bill/getBillList", map);
    }

    @Override
    public void exportBillList(String partnerId, String token, Map<String, String> map, HttpServletResponse response) {
        log.info("exportBillList partnerId: {}, token: {},  map:{}", new Object[]{partnerId, token, map});
        map.put("render", "json");
        JSONObject jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm/bill/exportBillList", map);
        JSONObject data = jsonObject.getJSONObject("data");
        JSONArray list = data.getJSONArray("list");
        List dataList = (List)JSONArray.parseObject((String)list.toJSONString(), List.class);
        JSONObject header = data.getJSONObject("header");
        this.export(header, dataList, data.getString("title"), "\u8d26\u5355\u8d39\u7528", response);
    }

    @Override
    public Object getConfirmationList(String partnerId, String token, Map<String, String> map) {
        log.info("getConfirmationList partnerId: {}, token: {},  map:{}", new Object[]{partnerId, token, map});
        return this.bjyPartnerService.bjyPost(partnerId, token, "scrm/bill/getConfirmationList", map);
    }

    @Override
    public Object confirm(String partnerId, String token, Map<String, String> map) {
        log.info("confirm partnerId: {}, token: {},  map:{}", new Object[]{partnerId, token, map});
        return this.bjyPartnerService.bjyPost(partnerId, token, "scrm/bill/confirm", map);
    }

    private void export(JSONObject heads, List<Map<String, String>> data, String title, String sheetName, HttpServletResponse response) {
        if (CollectionUtils.isEmpty((Map)heads)) {
            return;
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(sheetName);
        HSSFRow row = sheet.createRow(0);
        row.setZeroHeight(false);
        row.setHeight((short)360);
        HSSFCellStyle headerCellStyle = workbook.createCellStyle();
        headerCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headerCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFFont headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerFont.setFontHeightInPoints((short)12);
        headerCellStyle.setFont((Font)headerFont);
        int size = heads.size();
        String[] headers = new String[size];
        ArrayList<String> fields = new ArrayList<String>(size);
        int headIndex = 0;
        for (Map.Entry head : heads.entrySet()) {
            headers[headIndex] = String.valueOf(head.getValue());
            fields.add(String.valueOf(head.getKey()));
            ++headIndex;
        }
        for (int i = 0; i < headers.length; ++i) {
            sheet.setColumnWidth(i, 6400);
            HSSFCell cell = row.createCell(i);
            cell.setCellStyle(headerCellStyle);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue((RichTextString)text);
        }
        if (!CollectionUtils.isEmpty(data)) {
            int rowNum = 1;
            for (Map<String, String> map : data) {
                HSSFRow ssRow = sheet.createRow(rowNum);
                this.createAndSetCell(ssRow, map, fields);
                ++rowNum;
            }
        }
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(title, "UTF-8"));
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.flushBuffer();
            workbook.write((OutputStream)response.getOutputStream());
        }
        catch (IOException e) {
            log.error("\u4fdd\u5b58excel\u5931\u8d25", (Throwable)e);
        }
    }

    private void createAndSetCell(HSSFRow ssRow, Map<String, String> map, List<String> fields) {
        for (int i = 0; i < fields.size(); ++i) {
            ssRow.createCell(i).setCellValue(String.valueOf(map.get(fields.get(i))));
        }
    }
}

