/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.sdk.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baijiayun.duanxunbao.common.dto.ResultError;
import com.baijiayun.duanxunbao.common.enums.ResultCode;
import com.baijiayun.duanxunbao.common.exception.BusinessException;
import com.baijiayun.duanxunbao.common.utils.JacksonUtil;
import com.baijiayun.duanxunbao.common.utils.MobileUtils;
import com.baijiayun.duanxunbao.sdk.dto.req.CallAddMemberDto;
import com.baijiayun.duanxunbao.sdk.dto.req.CallApplyExtenReq;
import com.baijiayun.duanxunbao.sdk.dto.req.CallConfig;
import com.baijiayun.duanxunbao.sdk.dto.req.CallEditMemberDto;
import com.baijiayun.duanxunbao.sdk.dto.req.CallForbiddenMemberDto;
import com.baijiayun.duanxunbao.sdk.dto.req.CallMemberDto;
import com.baijiayun.duanxunbao.sdk.dto.req.CallOutDto;
import com.baijiayun.duanxunbao.sdk.dto.req.CallRegisterReq;
import com.baijiayun.duanxunbao.sdk.dto.req.CallReleaseReq;
import com.baijiayun.duanxunbao.sdk.dto.req.CallSigninOutDto;
import com.baijiayun.duanxunbao.sdk.dto.req.CallVoiceParamDto;
import com.baijiayun.duanxunbao.sdk.dto.req.CallVoiceUrlDto;
import com.baijiayun.duanxunbao.sdk.service.BjyPartnerService;
import com.baijiayun.duanxunbao.sdk.service.CallService;
import com.baijiayun.duanxunbao.sdk.utils.ApiTypeEnum;
import com.baijiayun.duanxunbao.sdk.utils.VoiceMaterialTypeEnum;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class CallServiceImpl
implements CallService {
    private static final Logger log = LoggerFactory.getLogger(CallServiceImpl.class);
    @Autowired
    private BjyPartnerService bjyPartnerService;

    @Override
    public Object callAnswerRegister(String partnerId, String token, CallRegisterReq req) {
        log.info("callAnswerRegister partnerId: {}, token: {},  reqDto:{}", new Object[]{partnerId, token, req});
        Map<String, String> params = this.getInRegisterParams(req.getCallType(), req.getCallSheetId());
        JSONObject resp = null;
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/call/answerRegister", params);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            resp = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return resp;
    }

    @Override
    public Object applyExten(String partnerId, String token, CallApplyExtenReq req) {
        log.info("applyExten partnerId: {}, token: {},  reqDto:{}", new Object[]{partnerId, token, req});
        Map<String, String> params = this.getApplyExtenParams(req.getPhone(), req.getUserId(), req.getName());
        JSONObject resp = null;
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/call/member/applyExten", params);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            resp = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return resp;
    }

    @Override
    public Object callRegister(String partnerId, String token, CallOutDto dto) {
        log.info("callRegister partnerId: {}, token: {},  dto:{}", new Object[]{partnerId, token, dto});
        Map<String, String> params = this.getCallParams(dto);
        JSONObject jsonObject = null;
        if (dto.getCallType().equals(ApiTypeEnum.LOCAL.getName())) {
            Preconditions.checkArgument((boolean)MobileUtils.isPhone((String)dto.getPhone()), (Object)"\u8bf7\u8f93\u516511\u4f4d\u624b\u673a\u53f7");
            try {
                jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/call/click2Call", params);
                int code = jsonObject.getIntValue("code");
                if (code != 0) {
                    throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
                }
                jsonObject = jsonObject.getJSONObject("data");
            }
            catch (Exception e) {
                log.error("sign error", (Throwable)e);
            }
        } else {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)dto.getSessionId()), (Object)"sessionId\u4e0d\u80fd\u4e3a\u7a7a");
            try {
                jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/call/callRegister", params);
                int code = jsonObject.getIntValue("code");
                if (code != 0) {
                    throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
                }
                jsonObject = jsonObject.getJSONObject("data");
            }
            catch (Exception e) {
                log.error("sign error", (Throwable)e);
            }
        }
        return jsonObject;
    }

    @Override
    public Object callRelease(String partnerId, String token, CallReleaseReq req) {
        log.info("callRelease partnerId: {}, token: {},  req:{}", new Object[]{partnerId, token, req});
        Map<String, String> params = this.getHangupParams(req.getSessionId());
        JSONObject jsonObject = null;
        try {
            jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/call/releaseCall", params);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            jsonObject = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return jsonObject;
    }

    @Override
    public Object callOpen(String partnerId, String token, CallConfig config) {
        log.info("callOpen partnerId: {}, token: {},  config:{}", new Object[]{partnerId, token, config});
        Map<String, String> params = this.getConfigParams(config);
        JSONObject jsonObject = null;
        try {
            jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/call/open", params);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            jsonObject = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return jsonObject;
    }

    @Override
    public Object callClose(String partnerId, String token) {
        log.info("callClose partnerId: {}, token: {}", (Object)partnerId, (Object)token);
        JSONObject jsonObject = null;
        try {
            jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/call/close", new HashMap<String, String>());
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            jsonObject = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return jsonObject;
    }

    @Override
    public Object callDeleteMember(String partnerId, String token, CallMemberDto dto) {
        log.info("callDeleteMember partnerId: {}, token: {},  dto:{}", new Object[]{partnerId, token, dto});
        Map<String, String> params = this.getDeleteMemberParams(dto.getUserId());
        JSONObject jsonObject = null;
        try {
            jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/call/member/delete", params);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            jsonObject = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return jsonObject;
    }

    @Override
    public Object callForbiddenMember(String partnerId, String token, CallForbiddenMemberDto dto) {
        log.info("callForbiddenMember partnerId: {}, token: {},  dto:{}", new Object[]{partnerId, token, dto});
        Map<String, String> params = this.getForbiddenMemberParams(dto.getStatus(), dto.getUserId());
        JSONObject jsonObject = null;
        try {
            jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/call/member/forbidden", params);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            jsonObject = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return jsonObject;
    }

    @Override
    public Object callAddMember(String partnerId, String token, CallAddMemberDto dto) {
        log.info("callAddMember partnerId: {}, token: {},  dto:{}", new Object[]{partnerId, token, dto});
        Map<String, String> params = this.getAddMemberParams(dto.getPhone(), dto.getName(), dto.getUserId());
        JSONObject jsonObject = null;
        try {
            jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/call/member/add", params);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            jsonObject = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return jsonObject;
    }

    @Override
    public Object callEditMember(String partnerId, String token, CallEditMemberDto dto) {
        log.info("callEditMember partnerId: {}, token: {},  dto:{}", new Object[]{partnerId, token, dto});
        Map<String, String> params = this.getEditMemberParams(dto.getNewPhone(), dto.getUserId());
        JSONObject jsonObject = null;
        try {
            jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/call/member/edit", params);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            jsonObject = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return jsonObject;
    }

    @Override
    public Object callMemberInfo(String partnerId, String token, CallMemberDto dto) {
        log.info("callMemberInfo partnerId: {}, token: {},  dto:{}", new Object[]{partnerId, token, dto});
        Map<String, String> params = this.getExtenInfoParams(dto.getUserId());
        JSONObject jsonObject = null;
        try {
            jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/call/member/info", params);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            jsonObject = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return jsonObject;
    }

    @Override
    public Object callSignInOut(String partnerId, String token, CallSigninOutDto dto) {
        log.info("callSignInOut partnerId: {}, token: {},  dto:{}", new Object[]{partnerId, token, dto});
        Map<String, String> params = this.getSignInOrOutParams(dto.getExten(), dto.getSignInType());
        JSONObject jsonObject = null;
        try {
            jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/call/member/signInOrOut", params);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            jsonObject = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return jsonObject;
    }

    @Override
    public Object callSessionId(String partnerId, String token) {
        log.info("callSessionId partnerId: {}, token: {}", (Object)partnerId, (Object)token);
        JSONObject jsonObject = null;
        try {
            jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/call/getCallSessionId", Maps.newHashMap());
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            jsonObject = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return jsonObject;
    }

    @Override
    public Object callLinesUrl(String partnerId, String token) {
        log.info("callLinesUrl partnerId: {}, token: {}", (Object)partnerId, (Object)token);
        HashMap params = Maps.newHashMap();
        params.put("partner_id", "0");
        JSONObject jsonObject = null;
        try {
            jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/call/getLines", params);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            jsonObject = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return jsonObject;
    }

    @Override
    public Object callVoiceUrl(String partnerId, String token, CallVoiceUrlDto dto) {
        log.info("callVoiceUrl partnerId: {}, token: {}, dto: {}", new Object[]{partnerId, token, dto});
        Map<String, String> params = this.getVoiceParams(dto.getUrl());
        JSONObject jsonObject = null;
        try {
            jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/call/getVoiceUrl", params);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            jsonObject = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return jsonObject;
    }

    @Override
    public Object callRlExtenList(String partnerId, String token) {
        log.info("callRlExtenList partnerId: {}, token: {}", (Object)partnerId, (Object)token);
        Map<String, String> params = this.getRlExtenListParams();
        JSONObject jsonObject = null;
        try {
            jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/call/rlExtenList", params);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            jsonObject = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return jsonObject;
    }

    @Override
    public Object callVoice(String partnerId, String token, CallVoiceParamDto dto) {
        log.info("callVoice partnerId: {}, token: {}, dto: {}", new Object[]{partnerId, token, dto});
        Map<String, String> params = this.handleVoiceParams(dto.getMobile(), dto.getContent(), dto.getType(), dto.getMaterialParams());
        JSONObject jsonObject = null;
        try {
            jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/call/voiceCall", params);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            jsonObject = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return jsonObject;
    }

    private Map<String, String> getInRegisterParams(String callType, String callSheetId) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("call_type", callType);
        result.put("call_sheet_id", callSheetId);
        return result;
    }

    private Map<String, String> getApplyExtenParams(String phone, Long userId, String name) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("phone", phone);
        result.put("name", name);
        result.put("user_number", String.valueOf(userId));
        return result;
    }

    private Map<String, String> getHangupParams(String sessionId) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("session_id", sessionId);
        return result;
    }

    private Map<String, String> getCallParams(CallOutDto callOutDto) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("tel_a", callOutDto.getUserPhone());
        result.put("tel_b", callOutDto.getPhone());
        result.put("user_number", String.valueOf(callOutDto.getUserId()));
        result.put("call_type", callOutDto.getCallType());
        if (StringUtils.isNotBlank((CharSequence)callOutDto.getSessionId())) {
            result.put("session_id", callOutDto.getSessionId());
        }
        return result;
    }

    private Map<String, String> getConfigParams(CallConfig callConfig) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("supplier_type", String.valueOf(callConfig.getSupplierType()));
        result.put("callback_host", callConfig.getCallbackHost());
        result.put("call_line", callConfig.getCallLine());
        if (!ObjectUtils.isEmpty((Object)callConfig.getAccountInfo())) {
            result.put("account_info", JacksonUtil.obj2Str((Object)callConfig.getAccountInfo()));
        }
        if (!ObjectUtils.isEmpty((Object)callConfig.getWebCallAccountInfo())) {
            result.put("account_webcall_info", JacksonUtil.obj2Str((Object)callConfig.getWebCallAccountInfo()));
        }
        if (!ObjectUtils.isEmpty((Object)callConfig.getDoubleCallAccountInfo())) {
            result.put("account_double_call_info", JacksonUtil.obj2Str((Object)callConfig.getDoubleCallAccountInfo()));
        }
        if (!ObjectUtils.isEmpty((Object)callConfig.getWebCallFeeInfo())) {
            result.put("webcall_fee_info", JacksonUtil.obj2Str((Object)callConfig.getWebCallFeeInfo()));
        }
        if (!ObjectUtils.isEmpty((Object)callConfig.getCallFeeInfo())) {
            result.put("call_fee_info", JacksonUtil.obj2Str((Object)callConfig.getCallFeeInfo()));
        }
        if (!ObjectUtils.isEmpty((Object)callConfig.getDoubleCallFeeInfo())) {
            result.put("double_call_fee_info", JacksonUtil.obj2Str((Object)callConfig.getDoubleCallFeeInfo()));
        }
        if (!ObjectUtils.isEmpty((Object)callConfig.getValidDate())) {
            result.put("exten_fee_valid_date", callConfig.getValidDate());
        }
        result.put("way_type", callConfig.getWayType());
        return result;
    }

    private Map<String, String> getDeleteMemberParams(Long userId) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("user_number", String.valueOf(userId));
        return result;
    }

    private Map<String, String> getForbiddenMemberParams(int status, Long userId) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("status", String.valueOf(status));
        result.put("user_number", String.valueOf(userId));
        return result;
    }

    private Map<String, String> getAddMemberParams(String phone, String name, Long userId) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("phone", phone);
        result.put("name", name);
        result.put("user_number", String.valueOf(userId));
        return result;
    }

    private Map<String, String> getEditMemberParams(String newPhone, Long userId) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("phone", newPhone);
        result.put("user_number", String.valueOf(userId));
        return result;
    }

    private Map<String, String> getExtenInfoParams(Long userId) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("user_number", String.valueOf(userId));
        return map;
    }

    private Map<String, String> getSignInOrOutParams(String exten, Integer signInType) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("exten", exten);
        result.put("sign_in", String.valueOf(signInType));
        return result;
    }

    private Map<String, String> getVoiceParams(String url) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("voice_path", url);
        return result;
    }

    private Map<String, String> getRlExtenListParams() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("is_login", "1");
        result.put("busy_type", "0");
        return result;
    }

    private Map<String, String> handleVoiceParams(String phone, String content, Integer materialTypeValue, Map<String, String> materialParams) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tel_b", phone);
        VoiceMaterialTypeEnum materialType = VoiceMaterialTypeEnum.get(materialTypeValue);
        if (VoiceMaterialTypeEnum.TEXT.equals((Object)materialType)) {
            params.put("type", "0");
            for (Map.Entry<String, String> param : materialParams.entrySet()) {
                String template = "{" + param.getKey() + "}";
                if (!content.contains(template)) continue;
                content = content.replace(template, param.getValue());
            }
            String base64Content = Base64.getEncoder().encodeToString(content.getBytes(StandardCharsets.UTF_8));
            params.put("text", base64Content);
        } else if (VoiceMaterialTypeEnum.VOICE.equals((Object)materialType)) {
            params.put("type", "1");
            params.put("file", content);
        }
        return params;
    }
}

