/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.baijiayun.duanxunbao.common.dto.ResultError;
import com.baijiayun.duanxunbao.common.enums.ResultCode;
import com.baijiayun.duanxunbao.common.exception.BusinessException;
import com.baijiayun.duanxunbao.common.utils.HttpClientUtils;
import com.baijiayun.duanxunbao.sdk.service.BjyPartnerService;
import com.baijiayun.duanxunbao.sdk.utils.UrlUtils;
import com.google.common.collect.Maps;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.util.DigestUtils;

@Service
@RefreshScope
public class BjyPartnerServiceImpl
implements BjyPartnerService {
    private static final Logger log = LoggerFactory.getLogger(BjyPartnerServiceImpl.class);
    @Value(value="${app.bjy.domain:}")
    private String bjyUrl;
    @Value(value="${app.bjy.salt:}")
    private String salt;
    @Value(value="${app.bjy.prefix:}")
    private String prefix;
    @Value(value="${app.bjy.apiDomain}")
    private String apiDomain;
    @Value(value="${app.bjy.appKey}")
    private String appKey;
    @Value(value="${app.bjy.appSecret}")
    private String appSecret;
    private final int TOKEN_CACHE_EXPIRE = 1;
    private final String TIMESTAMP = "timestamp";
    private final String ERROR_MSG = "\u8c03\u7528API\u5f02\u5e38";

    @Override
    public void setSign(Map<String, String> params) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            if (entry.getValue() == null) continue;
            params.put(entry.getKey(), entry.getValue().trim());
        }
        params.put("sign", this.getMd5Sign(params));
    }

    @Override
    public JSONObject bjyPost(String url, Map<String, String> map, Map<String, String> header) {
        String result;
        log.info("bjyPost url:{},params:{}", (Object)(this.bjyUrl + url), map);
        Map<String, String> params = this.putTimestamp(map);
        this.setSign(params);
        String postUrl = UrlUtils.assembleUrl(this.bjyUrl, url);
        try {
            result = HttpClientUtils.doPost((String)postUrl, params, header, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            log.error("bjy api post error", (Throwable)e);
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "\u8c03\u7528API\u5f02\u5e38");
        }
        JSONObject jsonObject = JSON.parseObject((String)result, (Feature[])new Feature[]{Feature.OrderedField});
        int code = jsonObject.getIntValue("code");
        String msg = jsonObject.getString("msg");
        switch (code) {
            case 0: {
                return jsonObject;
            }
            case 30004: {
                log.warn("bjyPost with header warn repeat");
                return jsonObject;
            }
        }
        log.error("bjyPost with header error,result:{}", (Object)result);
        throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, msg);
    }

    @Override
    public JSONObject bjyPost(String partnerId, String token, String url, Map<String, String> map) {
        String result;
        log.info("bjyPost url:{},params:{}", (Object)(this.bjyUrl + url), map);
        HashMap<String, String> bjyHeader = new HashMap<String, String>(1);
        bjyHeader.put("Authorization", this.prefix + token);
        Map<String, String> params = this.putTimestamp(map);
        map.put("partner_id", partnerId);
        this.setSign(params);
        String postUrl = UrlUtils.assembleUrl(this.bjyUrl, url);
        try {
            result = HttpClientUtils.doPost((String)postUrl, params, bjyHeader, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            log.error("bjy api post error", (Throwable)e);
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "\u8c03\u7528API\u5f02\u5e38");
        }
        JSONObject jsonObject = JSON.parseObject((String)result, (Feature[])new Feature[]{Feature.OrderedField});
        int code = jsonObject.getIntValue("code");
        String msg = jsonObject.getString("msg");
        log.info("bjyPost params:{} ,result:{}", params, (Object)result);
        switch (code) {
            case 0: {
                return jsonObject;
            }
            case 30004: {
                log.warn("bjyPost warn repeat");
                return jsonObject;
            }
            case 31002: {
                log.warn("bjyPost voice call phone limie");
                return jsonObject;
            }
            case 31003: {
                log.warn("bjyPost voice call speed limit");
                return jsonObject;
            }
            case 31004: {
                log.warn("bjyPost voice call text over length");
                return jsonObject;
            }
        }
        log.error("bjyPost error,result:{}", (Object)result);
        throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, msg);
    }

    @Override
    public JSONObject bjyPost(String partnerId, String url, Map<String, String> params) {
        String result;
        log.info("bjyPost partnerId: {}, url:{},params:{}", new Object[]{partnerId, this.bjyUrl + url, params});
        params = this.putTimestamp(params);
        params.put("partner_id", partnerId);
        this.setSign(params);
        String postUrl = UrlUtils.assembleUrl(this.bjyUrl, url);
        try {
            result = HttpClientUtils.doPost((String)postUrl, params);
        }
        catch (Exception e) {
            log.error("bjy api post error", (Throwable)e);
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "\u8c03\u7528API\u5f02\u5e38");
        }
        JSONObject jsonObject = JSON.parseObject((String)result, (Feature[])new Feature[]{Feature.OrderedField});
        int code = jsonObject.getIntValue("code");
        String msg = jsonObject.getString("msg");
        log.info("bjyPost params:{} ,result:{}", params, (Object)result);
        switch (code) {
            case 0: {
                return jsonObject;
            }
            case 30004: {
                log.warn("bjyPost warn repeat");
                return jsonObject;
            }
            case 31002: {
                log.warn("bjyPost voice call phone limie");
                return jsonObject;
            }
            case 31003: {
                log.warn("bjyPost voice call speed limit");
                return jsonObject;
            }
            case 31004: {
                log.warn("bjyPost voice call text over length");
                return jsonObject;
            }
        }
        log.error("bjyPost error,result:{}", (Object)result);
        throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, msg);
    }

    private String getMd5Sign(Map<String, String> params) {
        log.info("getMd5Sign params:{}", params);
        StringBuilder sb = new StringBuilder();
        sb.append(this.salt);
        sb.append(':');
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        sorted.putAll(params);
        for (Map.Entry entry : sorted.entrySet()) {
            sb.append((String)entry.getValue());
            sb.append('$');
        }
        String sign = sb.toString();
        sign = sign.substring(0, sign.length() - 1);
        log.info("getMd5Sign sign before:{}", (Object)sign);
        sign = DigestUtils.md5DigestAsHex((byte[])sign.getBytes());
        log.info("getMd5Sign sign after:{}", (Object)sign);
        return sign;
    }

    private String getMd5SignByOpenApi(Map<String, String> params) {
        log.info("getMd5SignByOpenApi params:{}", params);
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        sorted.putAll(params);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : sorted.entrySet()) {
            sb.append((String)entry.getKey());
            sb.append('=');
            sb.append((String)entry.getValue());
            sb.append('&');
        }
        sb.append("app_secret=");
        sb.append(this.appSecret);
        log.info("getMd5SignByOpenApi sign before:{}", (Object)sb.toString());
        String sign = DigestUtils.md5DigestAsHex((byte[])sb.toString().getBytes());
        log.info("getMd5SignByOpenApi sign after:{}", (Object)sign);
        return sign;
    }

    private Map<String, String> putTimestamp(Map<String, String> map) {
        map.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return map;
    }

    @Override
    public String getCityByIp(String ip) {
        if (StringUtils.isBlank((CharSequence)ip)) {
            return null;
        }
        HashMap params = Maps.newHashMap();
        params.put("ips", ip);
        try {
            JSONArray jsonArr;
            JSONObject result = this.bjyGet("scrm_api/ip/batchGetIpInfo", params);
            JSONObject data = result.getJSONObject("data");
            if (data != null && (jsonArr = data.getJSONArray(ip)) != null) {
                return jsonArr.getString(2);
            }
        }
        catch (Exception e) {
            log.error("get city by ip error: ", (Throwable)e);
        }
        return null;
    }

    private JSONObject bjyGet(String url, Map<String, String> map) {
        String result;
        Map<String, String> params = this.putTimestamp(map);
        this.setSign(params);
        log.info("bjyGet url:{},params:{}", (Object)(this.bjyUrl + url), params);
        try {
            result = HttpClientUtils.doGet((String)(this.bjyUrl + url), params, (Charset)StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            log.error("bjy api get error", (Throwable)e);
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "\u8c03\u7528API\u5f02\u5e38");
        }
        JSONObject jsonObject = JSON.parseObject((String)result, (Feature[])new Feature[]{Feature.OrderedField});
        int code = jsonObject.getIntValue("code");
        String msg = jsonObject.getString("msg");
        log.info("bjyGet params:{} ,result:{}", params, (Object)result);
        switch (code) {
            case 0: {
                return jsonObject;
            }
            case 30004: {
                log.warn("bjyGet warn repeat");
                return jsonObject;
            }
        }
        log.error("bjyGet error,result:{}", (Object)result);
        throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, msg);
    }

    @Override
    public JSONObject bjyPostByOpenApi(String url, Map<String, String> params) {
        String result;
        log.info("bjyPostByOpenApi url:{},params:{}", (Object)url, params);
        if (params == null) {
            params = Maps.newHashMap();
        }
        params.put("app_key", this.appKey);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        String sign = this.getMd5SignByOpenApi(params);
        params.put("sign", sign);
        try {
            String postUrl = UrlUtils.assembleUrl(this.apiDomain, url);
            result = HttpClientUtils.doPost((String)postUrl, (Map)params);
        }
        catch (Exception e) {
            log.error("bjyPostByOpenApi,bjy api post error", (Throwable)e);
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "\u8c03\u7528API\u5f02\u5e38");
        }
        JSONObject jsonObject = JSON.parseObject((String)result, (Feature[])new Feature[]{Feature.OrderedField});
        log.info("bjyPostByOpenApi params:{} ,result:{}", (Object)params, (Object)jsonObject);
        return jsonObject;
    }
}

