/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.openapi.sdk.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class DoublePrecisionSerializer
extends JsonSerializer<Number> {
    private final DecimalFormat formatter = new DecimalFormat("0.00");

    public DoublePrecisionSerializer() {
        this.formatter.setRoundingMode(RoundingMode.HALF_UP);
    }

    public void serialize(Number value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        BigDecimal bigDecimal = new BigDecimal(String.valueOf(value));
        String format = this.formatter.format(bigDecimal);
        double dbl = Double.parseDouble(format);
        gen.writeNumber(dbl);
    }
}

