/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.openapi.sdk;

import com.baijiayun.openapi.sdk.BjyClientInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BjyClientFactory {
    private static final Logger log = LoggerFactory.getLogger(BjyClientFactory.class);
    private final Map<Class<?>, Object> cache;
    private final BjyClientInvocationHandler handler = new BjyClientInvocationHandler();

    public BjyClientFactory() {
        this.cache = new HashMap();
    }

    public <T> T create(Class<T> clazz) {
        if (this.cache.containsKey(clazz)) {
            return (T)this.cache.get(clazz);
        }
        Object client = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{clazz}, (InvocationHandler)this.handler);
        this.cache.put(clazz, client);
        if (log.isDebugEnabled()) {
            log.debug("create client: {}", (Object)clazz.getName());
        }
        return (T)client;
    }
}

