package com.baijiayun.openapi.sdk.event;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class BjyTranscodeEventData implements Serializable {

    @JsonProperty("partner_id")
    private String partnerId; // 百家云商户ID

    @JsonProperty("room_id")
    private String roomId; // 房间ID

    @JsonProperty("video_id")
    private String videoId; // 视频ID / 云端录制视频ID

    private Integer status; // 视频状态（20:开始生成回放 30:转码失败 100:转码成功

    @JsonProperty("preface_url")
    private String prefaceUrl; // 封面url，（转码成功回调才有）

    @JsonProperty("play_url")
    private String playUrl; // 回放播放url，（转码成功回调才有）

    @JsonProperty("total_transcode_size")
    private Long totalTranscodeSize; // 总视频大小（源文件+所有转码后文件）单位：字节（转码成功回调才有）

    @JsonProperty("total_size")
    private Long totalSize; // 视频大小，单位是字节 （转码成功回调才有）

    private Long length; // 视频时长，单位为秒（转码成功回调才有）

    @JsonProperty("file_md5")
    private String fileMd5; // 视频文件md5值（转码成功回调才有）

    private String qid; // 标记一次请求的唯一ID

    private String timestamp; // unixstamp时间戳，秒数

    private String sign; // 签名字段

    @JsonProperty("session_id")
    private String sessionId;

}
