package com.baijiayun.openapi.sdk.event;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.Date;

@Data
public class BjyChatMsgEventReference {

    @JsonProperty("send_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8", shape = JsonFormat.Shape.STRING)
    private Date sendTime;

    @JsonProperty("user_id")
    private String userId;// 用户 Number

    /**
     *  用户角色，0:学生，1:老师，2:助教 3:游客
     * */
    @JsonProperty("user_role")
    private Integer userRole;// 用户角色，0:学生，1:老师，2:助教 3:游客

    private String nickname;// 昵称

    private String content;// 内容

    @JsonProperty("avatar")
    private String avatar;// 头像

    @JsonProperty("group_id")
    private Integer groupId;// 所在分组id

    @JsonProperty("group_name")
    private String groupName;// 所在分组名称
}
