package com.baijiayun.openapi.sdk.event;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 直播间聊天消息回调
 */
@Data
public class BjyChatMsgEvent implements Serializable {

    @JsonProperty("room_id")
    private String roomId;

    @JsonProperty("send_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8", shape = JsonFormat.Shape.STRING)
    private Date sendTime;

    @JsonProperty("user_id")
    private String userId;

    @JsonProperty("customstr")
    private String customStr;

    /**
     *  用户角色，0:学生，1:老师，2:助教 3:游客
     * */
    @JsonProperty("user_role")
    private Integer userRole;

    /**
     *  发送消息角色， 0:学生，1:老师，2:助教 3:游客
     * */
    @JsonProperty("send_msg_role")
    private Integer sendMsgRole;

    @JsonProperty("nickname")
    private String nickname;

    private String content;

    private String city;

    private String ip;

    /**
     *  虚拟消息，0:否 1:是
     * */
    @JsonProperty("is_virtual_chat")
    private Integer isVirtualChat;

    private String avatar;

    /**
     *  是否是过滤消息，0:否 1:是
     * */
    private Integer filtered;

    /**
     *  引用对象 存的json
     * */
    private BjyChatMsgEventReference reference;

}
