package com.baijiayun.openapi.sdk.enums;

import lombok.Getter;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * 视频转码状态
 *
 * @author yanmaoyuan
 * @date 2024/6/28
 */
@Getter
public enum BjyVideoStatus {
    DELETED(-1, "已删除"),
    NEW(10, "上传中"),
    UPLOADED(20, "转码中"),
    FAIL_TRANSCODE(30, "转码失败"),
    FAIL_TRANSCODE_TIMEOUT(31, "转码超时"),
    FAIL_UPLOAD_TIMEOUT(32, "上传超时"),
    SUCC_TRANSCODE(100, "转码成功");

    private final Integer value;
    private final String desc;

    BjyVideoStatus(Integer value, String desc) {
        this.value = value;
        this.desc= desc;
    }

    private static final Map<Integer, BjyVideoStatus> CACHE;
    static {
        Map<Integer, BjyVideoStatus> map = new HashMap<>();
        for (BjyVideoStatus status : BjyVideoStatus.values()) {
            map.put(status.value, status);
        }
        CACHE = Collections.unmodifiableMap(map);
    }

    public static BjyVideoStatus getByValue(Integer value) {
        return CACHE.get(value);
    }
}
