package com.baijiayun.openapi.sdk.enums;

import lombok.Getter;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2023/12/21
 */
@Getter
public enum BjyUserRole {
    STUDENT(0, "学生"),
    TEACHER(1, "老师"),
    ASSIST(2, "助教");

    private final int value;
    private final String desc;

    BjyUserRole(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static BjyUserRole getByValue(Integer value) {
        if (value == null) {
            return null;
        }
        for (BjyUserRole role : BjyUserRole.values()) {
            if (role.value == value) {
                return role;
            }
        }
        return null;
    }
}
