package com.baijiayun.openapi.sdk.enums;

import lombok.Getter;

/**
 * 百家云信令类型
 *
 * desc: 进入教室:in 离开教室:out 摄像头开启:camera_on 摄像头关闭:camera_off 上课:live_start 下课:live_end
 *
 * @author yanmaoyuan
 * @date 2024/1/9
 */
@Getter
public enum BjySignalBehavior {
    IN("in", "进入教室"),
    OUT("out", "离开教室"),
    CAMERA_ON("camera_on", "摄像头开启"),
    CAMERA_OFF("camera_off", "摄像头关闭"),
    LIVE_START("live_start", "上课"),
    LIVE_END("live_end", "下课"),
    BLOCKED_USER("blocked_user", "将某个用户拉黑"),
    BLOCKED_USER_FREE("blocked_user_free", "解除某个用户黑名单"),
    BLOCKED_USER_FREE_ALL("blocked_user_free_all", "解除全体用户黑名单"),
    PRODUCT_SHELF_CHANGE("product_shelf_change", "讲解商品"),
    MESSAGE_SEND_FORBID("message_send_forbid", "禁言"),
    MESSAGE_SEND_FORBID_ALL("message_send_forbid_all", "全体禁言")
    ;

    private final String value;
    private final String desc;

    BjySignalBehavior(String value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static BjySignalBehavior getByValue(String value) {
        if (value == null || value.isEmpty()) {
            return null;
        }
        for (BjySignalBehavior signal : BjySignalBehavior.values()) {
            if (signal.value.equals(value)) {
                return signal;
            }
        }
        return null;
    }
}
