package com.baijiayun.openapi.sdk.dto.videodata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetPlaybackWatchRecordReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 教室号
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * 序列号（针对长期房间才会用到）
     */
    @JsonProperty("session_id")
    private String sessionId;

    /**
     * 裁剪的版本号，取值正整数。默认主版本
     */
    private Integer version;

    /**
     * [必填] start_date 查询起始时间，格式如：2017-09-08
     */
    @JsonProperty("start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;

    /**
     * [必填] end_date 查询结束时间，格式如：2017-09-08。查询时间不能超过 7 天
     */
    @JsonProperty("end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;

    /**
     * 页码，从 1 开始，默认值是 1
     */
    private Integer page;

    /**
     * 每页获取的记录条数，默认 100，最大值不能超过 1000
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}