package com.baijiayun.openapi.sdk.dto.videodata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetPlaybackRealtimeRecordReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 回放教室号
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * 序列号（针对长期房间才会用到）, 多个英文逗号分隔
     */
    @JsonProperty("session_ids")
    private String sessionIds;

    /**
     * 裁剪的版本号，取值正整数。默认值 0
     */
    private Integer version;

    /**
     * [必填] start_time 查询起始时间，格式如：2017-09-08 00:30:00。
     */
    @JsonProperty("start_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    /**
     * [必填] end_time 查询结束时间，格式如：2017-09-08 23:59:59。查询时间不能跨天
     */
    @JsonProperty("end_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;

    /**
     * 页码，从1开始，默认值是1
     */
    private Integer page;

    /**
     * 每页获取的记录条数，默认100，最大值不能超过1000
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}