package com.baijiayun.openapi.sdk.dto.videodata;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class GetMergePlaybackWatchRecordReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 教室号
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * 序列号（针对长期房间才会用到）
     */
    @JsonProperty("session_id")
    private String sessionId;

    /**
     * 页码，从 1 开始，默认值是 1
     */
    private Integer page;

    /**
     * 每页获取的记录条数，默认 100，最大值不能超过 1000
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}