package com.baijiayun.openapi.sdk.dto.video;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class TranscodeAgainReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] video_id 视频id
     */
    @JsonProperty("video_id")
    private String videoId;

    /**
     * [必填] definition 目标清晰度(16:标清 1:高清 2:超清 4:720p 8:1080p 多种清晰度用英文逗号分隔)
     */
    private String definition;

    /**
     * 转码格式（1:mp42:flv4:m3u8多种格式用英文逗号分隔）默认是3种格式都转
     */
    private String format;
}