package com.baijiayun.openapi.sdk.dto.video;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class RemoveDefinitionReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] video_id 视频id
     */
    @JsonProperty("video_id")
    private String videoId;

    /**
     * [必填] definition 目标清晰度(16:标清[320*180] 1:高清[640*360] 2:超清[960*544] 4:720P[1280*720] 8:1080p[1920*1080] 多种清晰度用英文逗号分隔)
     */
    private String definition;

    /**
     * 目标类型(1:mp4 2:flv 4:m3u8/hls 8:encrypt 多种类型用英文逗号分隔)
     */
    private String type;
}