package com.baijiayun.openapi.sdk.dto.video;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class GetUrlReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] video_id 视频ID
     */
    @JsonProperty("video_id")
    private String videoId;

    /**
     * 视频格式，可选值有：mp4/m3u8/flv/encrypt，默认是mp4，encrypt表示加密格式，账号开启了点播加密功能才会有该格式的视频
     */
    private String format;

    /**
     * 视频失效时间，单位为秒，默认是12小时
     */
    @JsonProperty("expires_in")
    private Integer expiresIn;
}