package com.baijiayun.openapi.sdk.dto.video;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class GetPlayerTokenBatchReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] video_ids 多个视频ID以英文逗号分隔
     */
    @JsonProperty("video_ids")
    private String videoIds;

    /**
     * [必填] expires_in 过期时间，以秒为单位。如果传0则表示不过期
     */
    @JsonProperty("expires_in")
    private Integer expiresIn;

    /**
     * 产品线类型，默认云点播（1:大班课 2:小班课 3:双师课堂 4:企业直播 5:云点播）
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;
}