package com.baijiayun.openapi.sdk.dto.video;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class GetCategoryVideoReq implements Serializable {
    private static final long serialVersionUID = -1L;

    private String name;

    /**
     * @see com.baijiayun.openapi.sdk.enums.BjyVideoStatus
     */
    private Integer status;

    /**
     * [必填] category_id 分类ID
     */
    @JsonProperty("category_id")
    private Integer categoryId;

    /**
     * 页码，默认1
     */
    private Integer page;

    /**
     * 每页条数，不得超过100，默认值20
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}