package com.baijiayun.openapi.sdk.dto.user;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class AddUserReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] role 角色id 0:学生 1:老师 2:管理员
     */
    private Integer role;

    /**
     * [必填] name 用户名
     */
    private String name;

    /**
     * [必填] phone_number 手机号
     */
    @JsonProperty("phone_number")
    private String phoneNumber;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 用户ID
     */
    @JsonProperty("user_sn")
    private String userSn;

    /**
     * 备注
     */
    private String remark;

    /**
     * [必填] password 用户密码
     */
    private String password;
}