package com.baijiayun.openapi.sdk.dto.sms;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 应用端发送短信(支持国内、国外手机号码)
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class SmsSendReq extends SmsBaseReq implements Serializable {

    public SmsSendReq() {
        setMethod("sms.send");
    }

    /**
     * 国家代码+手机号，多条请用英文逗号隔开，最多2000个号码，例:8613500000000,82108800000
     */
    private String mobile;

    /**
     * 短信签名
     */
    private String signName;

    /**
     * 国内手机号码：短信内容，最多支持950个字符；国际手机号码：GSM 字符（A-Z/0-9/空格/!@#$%^&*()_+-=<>,./?）单条短信 140 个字符，超过 140 个字 符的拆分短信每条容纳 134 个字符，最多能支持 8个计费的长短信。 Unicode 字符（中文/日文/泰文/等特殊字符）单条短信 70 个字符，超过 70 个字符的拆分 短信每条容纳 67 个字符 ，最多能支持 8个计费的长短信。（注意： 只要短信里有一个字 符是中文/日文/泰文/等特殊字符的话都会按照该规范计算.）
     */
    private String msg;
}
