package com.baijiayun.openapi.sdk.dto.sms;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * desc:
 *
 * @author yanmaoyuan
 */
@Data
public class SmsBaseReq implements Serializable {

    /**
     * 必填 业务方法,如 发送短信为 ‘sms.send’
     */
    private String method;

    /**
     * 必填 接口版本 如1.0
     */
    private String version;

    /**
     * 必填 当前时间 如2020-03-25 12:09:10
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date time;

    /**
     * 必填 任务ID
     */
    @JsonProperty("task_id")
    private String taskId;
}
