package com.baijiayun.openapi.sdk.dto.roomscore;

import com.baijiayun.openapi.sdk.utils.UnixTimestampSerializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetUserScoreListReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 教室 id
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * [必填] date 日期
     */
    @JsonSerialize(using = UnixTimestampSerializer.class)
    private Date date;

    /**
     * 分页参数
     */
    private Integer page;

    /**
     * 每页返回条数
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}