package com.baijiayun.openapi.sdk.dto.roomdata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

@Data
public class GetUserEventDownloadUrlBatchReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_ids 英文逗号分隔的教室号列表
     */
    @JsonProperty("room_ids")
    private String roomIds;

    /**
     * 查询日期，格式如：2018-03-02
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date;

    /**
     * 链接失效时间
     */
    @JsonProperty("expires_in")
    private Integer expiresIn;
}