package com.baijiayun.openapi.sdk.dto.roomdata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

@Data
public class GetRoomRaiseDataReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * [必填] start_time
     */
    @JsonProperty("start_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;

    /**
     * [必填] end_time
     */
    @JsonProperty("end_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;
}