package com.baijiayun.openapi.sdk.dto.roomdata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

@Data
public class GetMediaLengthByDateReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 教室id
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * [必填] start_date 起始日期
     */
    @JsonProperty("start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;

    /**
     * [必填] end_date 结束日期
     */
    @JsonProperty("end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;
}