package com.baijiayun.openapi.sdk.dto.roomdata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetFilteredChatMsgReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * [必填] source_file 下载源文件还是csv文件，0csv（限制了内容，最大4万条,源文件最大5M），1源文件
     */
    @JsonProperty("source_file")
    private Integer sourceFile;

    /**
     * [必填] date 日期
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date;
}