package com.baijiayun.openapi.sdk.dto.roomdata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

@Data
public class GetEvaluationStatReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 教室号
     */
    @JsonProperty("room_id")
    private String roomId;

    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date;

    /**
     * [必填] page 页码 默认值1
     */
    private Integer page;

    /**
     * [必填] page_size 每页数量 默认值20
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}