package com.baijiayun.openapi.sdk.dto.roomdata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

@Data
public class GetEvaluationListReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] date 日期(2020-01-01)
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date;

    /**
     * 当前页数
     */
    private Integer page;

    /**
     * 每一页大小，默认100条
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}