package com.baijiayun.openapi.sdk.dto.roomdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

@Data
public class ExportLiveReportResp implements Serializable {

    private Integer total;

    @JsonProperty("room_user_info")
    private List<ExportLiveReportDto> roomUserInfo;

    /**
     * 课堂事件
     * <p>仅在 detail=1 时返回</p>
     *
     * <p>教室事件，键为日期，值为课堂事件列表，每个事件用中划线分割，格式为：开始时间-结束时间。如：</p>
     * <code>"class_event":{"2024-06-27":"1719478299-1719481354,1719481355-1719482201","2024-06-28":""}</code>
     */
    @JsonProperty("class_event")
    private Map<String, String> classEvent;
}
