package com.baijiayun.openapi.sdk.dto.roomdata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class ExportLiveReportDto implements Serializable {

    private String date;// 日期

    @JsonProperty("user_number")
    private String userNumber;

    @JsonProperty("user_name")
    private String userName;

    /**
     * 0:学生 1:老师 2:助教
     * @see com.baijiayun.openapi.sdk.enums.BjyUserRole
     */
    @JsonProperty("user_role")
    private Integer userRole;

    @JsonProperty("first_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date firstTime;

    @JsonProperty("last_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastTime;

    @JsonProperty("first_heartbeat_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date firstHeartbeatTime;

    @JsonProperty("last_heartbeat_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date lastHeartbeatTime;

    /**
     * 实际听课时长，指上课状态下，学生在教室的时间，多次进出教室情况是把每一小段时间累加（单位秒)
     */
    @JsonProperty("actual_listen_time")
    private Integer actualListenTime;

    /**
     * 用户IP
     */
    @JsonProperty("user_ip")
    private String userIp;

    /**
     * 用户所属省份
     */
    private String area;

    /**
     * 用户所属城市
     */
    private String city;

    /**
     * 使用的网络运营商
     */
    @JsonProperty("network_operator")
    private String networkOperator;

    /**
     * 在教室中的分组
     */
    @JsonProperty("group_id")
    private Integer groupId;

    @JsonProperty("is_audition")
    private Integer isAudition;

    /**
     * 0:PC网页 1:pc客户端 2:m站 3:ios 4:android 5:mac客户端 6:微信小程序
     */
    @JsonProperty("client_type")
    private Integer clientType;

    /**
     * <p>用户进出直播间的事件，每个事件用中划线分割，格式为：开始时间-结束时间，如:</p>
     *
     * <p>仅在 detail=1 时才返回</p>
     *
     * <code>"user_event":"1719478685-1719483573,1719483579-1719486481"</code>
     */
    @JsonProperty("user_event")
    private String userEvent;
}
