package com.baijiayun.openapi.sdk.dto.roomdata;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class ExportChatMsgReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 教室号
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * 日期
     * <p>没传递时，长期教室是最近上课的一天，短期教室默认是这次课的所有聊天信息</p>
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date;
}