package com.baijiayun.openapi.sdk.dto.room;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class SetRoomPasswordReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 教室ID
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * [必填] password 房间密码 1-20位数字或字母组合
     */
    private String password;

    /**
     * 0:非密码观看限制的教室不能设置密码 1:非密码观看限制的教室强制修改成密码观看限制并设置密码。
     * 不设置的话，默认为0，返回错误码1001，“该教室非密码观看限制,无法修改密码!”
     **/
    private Integer force;
}