package com.baijiayun.openapi.sdk.dto.room;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.File;
import java.io.Serializable;

@Data
public class SetLiveRoomGroupLogoReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id room_id
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * [必填] group_id 分组id
     */
    @JsonProperty("group_id")
    private Long groupId;

    /**
     * [必填] m-loading H5端教室加载页logo，图片类型png
     */
    @JsonProperty("m-loading")
    private File mLoading;

    /**
     * [必填] m-no-ppt H5端教室内无PPT时的封面页，图片类型png
     */
    @JsonProperty("m-no-ppt")
    private File mNoPpt;

    /**
     * [必填] www-classroom PC客户端或网页端教室内logo，图片类型png
     */
    @JsonProperty("www-classroom")
    private File wwwClassroom;

    /**
     * [必填] www-favicon PC网页端标签logo，图片类型ico
     */
    @JsonProperty("www-favicon")
    private File wwwFavicon;

    /**
     * [必填] www-loading PC客户端或网页端的加载页logo，图片类型png
     */
    @JsonProperty("www-loading")
    private File wwwLoading;

    /**
     * [必填] www-no-ppt PC客户端或网页端无PPT时的背景logo，图片类型png
     */
    @JsonProperty("www-no-ppt")
    private File wwwNoPpt;
}