package com.baijiayun.openapi.sdk.dto.room;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class ListGroupCodeUserReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 直播间id
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * [必填] group_code_id 分组id，通过/openapi/room/getGroupLiveCodes可获得
     */
    @JsonProperty("group_code_id")
    private Long groupCodeId;

    /**
     * 页数 最低从1开始
     */
    private Integer page;

    /**
     * 每页最大返回条数为1000条
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}