package com.baijiayun.openapi.sdk.dto.room;

import com.baijiayun.openapi.sdk.utils.UnixTimestampDeserializer;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class ListDto implements Serializable {

    @JsonProperty("room_id")
    private String roomId;

    /**
     * 直播课标题
     */
    private String title;

    /**
     * 开始时间, unix时间戳
     */
    @JsonProperty("start_time")
    @JsonDeserialize(using = UnixTimestampDeserializer.class)
    private Date startTime;

    /**
     * 结束时间, unix时间戳
     */
    @JsonProperty("end_time")
    @JsonDeserialize(using = UnixTimestampDeserializer.class)
    private Date endTime;

    /**
     * 创建时间, unix时间戳
     */
    @JsonProperty("create_time")
    @JsonDeserialize(using = UnixTimestampDeserializer.class)
    private Date createTime;

    /**
     * 1:一对一课 2:大班课
     * @see com.baijiayun.openapi.sdk.enums.BjyRoomType
     */
    private Integer type;

    /**
     * 是否是长期房间，0否，1是
     */
    @JsonProperty("is_long_term")
    private Integer isLongTerm;

    /**
     * 代表教室内最大人数
     */
    @JsonProperty("max_users")
    private Integer maxUsers;

    /**
     * 管理员进入房间的参加码
     */
    @JsonProperty("admin_code")
    private String adminCode;

    /**
     * 老师进入房间的参加码
     */
    @JsonProperty("teacher_code")
    private String teacherCode;

    /**
     * 学生进入房间的参加码
     */
    @JsonProperty("student_code")
    private String studentCode;

    /**
     * 0:表示教育
     */
    @JsonProperty("industry_type")
    private Integer industryType;

    /**
     * 1未开播，2直播中，3已开播，4回放中（开启跳转回放并回放已生成）
     */
    @JsonProperty("new_live_status")
    private Integer newLiveStatus;

    /**
     * 教室来源（1:开放平台api接口 2:管理后台 3:直播APP创建 4:DEMO页面创建 5:云端课堂后台 6:双师辅助教室 7:分组母教室 8:小班课后台系统 9:商务直播后台 10:双师辅助非webrtc教室 11:brtc 12:自习室场外辅导）
     */
    @JsonProperty("create_from")
    private Integer createFrom;

    /**
     * 是否是通过手机验证进入
     * <ul>
     *  <li>0 直接进教室</li>
     *  <li>1 课程私密参加码</li>
     *  <li>2 公开参加码</li>
     *  <li>3 白名单进教室</li>
     *  <li>4 密码观看</li>
     *  <li>5 云端直播白名单</li>
     *  <li>6 手机验证</li>
     * </ul>
     * <p>默认值: 0</p>
     */
    @JsonProperty("is_private")
    private Integer isPrivate;

    /**
     * 0:视频 1:音频
     */
    @JsonProperty("media_type")
    private Integer mediaType;

    /**
     * 是否允许分享 0:默认 1:开启 2:关闭
     */
    @JsonProperty("enable_share")
    private Integer enableShare;

    /**
     * 可提前进入秒数
     */
    @JsonProperty("pre_enter_time")
    private Integer preEnterTime;

    /**
     * 是否是伪直播 0：否 1: 是
     */
    @JsonProperty("is_mock_live")
    private Integer isMockLive;

    /**
     * 是否是推流直播 0:否 1:是
     */
    @JsonProperty("is_push_live")
    private Integer isPushLive;

    /**
     * 台下最大人数
     */
    @JsonProperty("max_backup_users")
    private Integer maxBackupUsers;

    /**
     * 0普通教室 1分组直播 2线上双师
     */
    @JsonProperty("new_group_live")
    private Integer newGroupLive;

    /**
     * 是否研讨会 0:否 1:是
     */
    @JsonProperty("is_discuss_live")
    private Integer isDiscussLive;

    /**
     * 学生发言时是否自动开启摄像头 1:开启 2:不开启
     * @see com.baijiayun.openapi.sdk.enums.BjySpeakCameraTurnOnEnum
     */
    @JsonProperty("speak_camera_turnon")
    private Integer speakCameraTurnon;

    /**
     * 老师是否自动检测设备 0:默认 1:检测 2:不检测
     */
    @JsonProperty("teacher_need_detect_device")
    private Integer teacherNeedDetectDevice;

    /**
     * 学生是否自动检测设备 0:默认 1:检测 2:不检测
     */
    @JsonProperty("student_need_detect_device")
    private Integer studentNeedDetectDevice;

    /**
     * 自动开启云端录制 0:默认 1:开启 2:使用本地配置
     */
    @JsonProperty("auto_playback_record")
    private Integer autoPlaybackRecord;

    /**
     * pc模板名
     */
    @JsonProperty("template_name")
    private String templateName;

    /**
     * app模版属性（横竖屏）
     */
    @JsonProperty("app_template")
    private Integer appTemplate;

    /**
     * 是否以视频为主，1=以视频为主，2=以PPT为主，0或不传使用默认值
     */
    @JsonProperty("is_video_main")
    private Integer isVideoMain;

    /**
     * 手机端模板是否以视频为主，1=以视频为主，2=以PPT为主，0或不传使用默认值
     */
    @JsonProperty("m_is_video_main")
    private Integer mIsVideoMain;

    /**
     * 微信用户获取昵称 0:默认 1：启用，2：不启用
     */
    @JsonProperty("enable_weixin_auth")
    private Integer enableWeixinAuth;

    /**
     * 系统自动分配昵称 0：不启用 1：启用
     */
    @JsonProperty("system_auto_allocate_name")
    private Integer systemAutoAllocateName;

    /**
     * 有无学生上麦，仅在webrtc班型上使用此参数 0：无，1：有
     * <p>默认值: 0</p>
     */
    @JsonProperty("has_student_raise")
    private Integer hasStudentRaise;

    /**
     * 大小班切换控制 1大班老师控制2小班老师控制
     */
    @JsonProperty("switch_room_role")
    private Integer switchRoomRole;

    /**
     * 分组课堂/线上双师 成员名单数据权限 0:成员只看组内权限 1:成员可看全部权限
     */
    @JsonProperty("enable_group_users_public")
    private Integer enableGroupUsersPublic;

    /**
     * 分组/线上双师 助教查看答题数据权限 0:助教查看组内答题数据 1:助教查看全部数据
     */
    @JsonProperty("group_admin_permission")
    private Integer groupAdminPermission;

    /**
     * 分组直播/线上双师 成员聊天数据权限 0:成员只看组内权限 1:成员可看全部权限
     */
    @JsonProperty("enable_group_chat_public")
    private Integer enableGroupChatPublic;

    /**
     * 课程预设的下课时间后可以拖堂的时间，到时间会强制下课，单位（秒），0不强制，大于0生效
     */
    @JsonProperty("end_delay_time")
    private Integer endDelayTime;

    /**
     * 是否使用带货直播模板。0:不使用 1:纯视频带货模板 2:ppt 带货模板
     * @see com.baijiayun.openapi.sdk.enums.BjyEnableLiveSell
     */
    @JsonProperty("enable_live_sell")
    private Integer enableLiveSell;

    /**
     * 是否开启三分屏带货，0不开启，1开启（仅enable_live_sell=0生效）
     */
    @JsonProperty("sell_goods_in_large_class")
    private Integer sellGoodsInLargeClass;

    /**
     * 伪直播,是否同步回放聊天消息 0：不同步 1：同步
     */
    @JsonProperty("enable_mock_sync_chat_message")
    private Integer enableMockSyncChatMessage;

    @JsonProperty("enable_ppt_page_down")
    private Integer enablePptPageDown;

    @JsonProperty("third_play")
    private Integer thirdPlay;
}
