package com.baijiayun.openapi.sdk.dto.room;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class InfoResp implements Serializable {

    @JsonProperty("room_id")
    private String roomId;// 房间id

    private String title;// 直播课标题

    @JsonProperty("start_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;// 开课时间，格式如：2017-08-18 14:00:00

    @JsonProperty("end_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;// 结束时间，格式如：2017-08-18 14:00:00

    private String type;// 1:一对一课 2:大班课

    @JsonProperty("is_long_term")
    private Integer isLongTerm;// 是否是长期房间，0否，1是

    @JsonProperty("max_users")
    private Integer maxUsers;// 直播间允许的最大人数

    @JsonProperty("admin_code")
    private String adminCode;// 管理员进入直播间的参加码

    @JsonProperty("teacher_code")
    private String teacherCode;// 老师进入直播间的参加码

    /**
     * 直播间创建方式
     * 1： 通过 openAPI 接口创建
     * 其他：通过百家云平台创建
     */
    @JsonProperty("create_from")
    private Integer createFrom;

    /**
     * 进入方式
     * 0 直接进教室，
     * 1 课程私密参加码，
     * 2 公开参加码，
     * 3 白名单进教室，
     * 4 密码观看，
     * 5 云端直播白名单，
     * 6 手机验证
     */
    @JsonProperty("is_private")
    private Integer isPrivate;

    /**
     *  是否分组，0:常规直播 1:分组课堂 2:线上双师
     * */
    @JsonProperty("new_group_live")
    private Integer newGroupLive;

    @JsonProperty("media_type")
    private Integer mediaType;// 0:视频 1:音频

    @JsonProperty("enable_share")
    private Integer enableShare;// 是否允许分享 0:默认 1:开启 2:关闭

    @JsonProperty("pre_enter_time")
    private Integer preEnterTime;// 可提前进入秒数

    @JsonProperty("max_backup_users")
    private Integer maxBackupUsers;// 台下最大人数

    /**
     * 自动开启云端录制 0:默认 1:开启 2:使用本地配置
     * */
    @JsonProperty("auto_playback_record")
    private Integer autoPlaybackRecord;

    /**
     *  是否是伪直播 0：否 1: 是
     * */
    @JsonProperty("is_mock_live")
    private Integer isMockLive;

    /**
     *  伪直播自动录制 1：是，0：否
     * */
    @JsonProperty("mock_live_record")
    private Integer mockLiveRecord;

    /**
     *  是否是推流直播 0:否 1:是
     * */
    @JsonProperty("is_push_live")
    private Integer isPushLive;

    /**
     *  推流直播自动录制 1：是，0：否
     * */
    @JsonProperty("push_live_record")
    private Integer pushLiveRecord;


    @JsonProperty("template_name")
    private String templateName;

    /**
     *  是否开启直播带货
     * */
    @JsonProperty("enable_live_sell")
    private Integer enableLiveSell;

    /**
     *  是否允许伪直播同步回放聊天消息
     * */
    @JsonProperty("enable_mock_sync_chat_message")
    private Integer enableMockSyncChatMessage;

    @JsonProperty("enable_set_virtual_chat_art")
    private Integer enableSetVirtualChatArt;

    @JsonProperty("is_discuss_live")
    private Integer isDiscussLive;// 研讨会

    /**
     *  直播间状态 -1 禁用 0 启用
     * */
    @JsonProperty("status")
    private Integer status;

    /**
     * 是否使用全局黑名单 1：开启，0:关闭，默认1
     */
    @JsonProperty("enable_live_global_blacklist")
    private Integer enableLiveGlobalBlacklist;
}
