package com.baijiayun.openapi.sdk.dto.room;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class GetCodeReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 房间ID
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * [必填] user_number 合作方账号体系下的用户ID号，必须是数字
     * user_number为0时，生成的是学生用户的通用邀请码，所有学生可使用该通用邀请码同时进入教室（免费课场景）。
     * user_number非0时，同一个学生邀请码只支持一人同时在线（收费课场景）。后进教室的学员会将之前进的人挤下线。
     */
    @JsonProperty("user_number")
    private String userNumber;

    /**
     * 用户头像，需要完整的url地址
     */
    @JsonProperty("user_avatar")
    private String userAvatar;

    /**
     * 如果同一个学员已经生成过试听参加码，则强制更新为普通参加码；传值为：1
     */
    @JsonProperty("update_audition_type")
    private Integer updateAuditionType;
}