package com.baijiayun.openapi.sdk.dto.room;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class GetAuditionCodeReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 房间ID
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * [必填] user_numbers 合作方账号体系下的用户ID号，必须是数字且要大于0,多个的话用逗号分隔
     */
    @JsonProperty("user_numbers")
    private String userNumbers;

    /**
     * 用户头像，需要完整的url地址
     */
    @JsonProperty("user_avatar")
    private String userAvatar;

    /**
     * [必填] audition_length 必须大于0，且不能超过3600，单位是秒数，值指的是具体试听时长
     */
    @JsonProperty("audition_length")
    private Integer auditionLength;
}