package com.baijiayun.openapi.sdk.dto.quiz;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2024/7/9
 */
@Data
public class GetRoomQuizListDto implements Serializable {

    /**
     * 房间ID
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * 合作者ID
     */
    @JsonProperty("partner_id")
    private String partnerId;

    /**
     * 试卷ID
     */
    @JsonProperty("paper_id")
    private Long paperId;

    /**
     * 试卷父ID
     */
    @JsonProperty("parent_paper_id")
    private Long parentPaperId;

    /**
     * 试卷标题
     */
    private String title;

    /**
     * 试卷文件名
     */
    @JsonProperty("file_name")
    private String fileName;

    /**
     * 是否强制参与
     */
    @JsonProperty("is_force")
    private Integer isForce;

    /**
     * 创建时间
     */
    @JsonProperty("create_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date createTime;

    /**
     * 更新时间
     */
    @JsonProperty("update_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date updateTime;
}
