package com.baijiayun.openapi.sdk.dto.playback;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class SetPlaybackValidDayReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 1:大班课，2，小班课，3：双师，4，企业直播
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;

    /**
     * 回放视频id，多个英文逗号拼接，不传则设置产品线级别有效期
     */
    @JsonProperty("video_ids")
    private String videoIds;

    /**
     * valid_day 有效期
     */
    @JsonProperty("valid_day")
    private Integer validDay;

    /**
     * 有效期类型，1：按天设置，2：按到期时间设置
     */
    @JsonProperty("valid_type")
    private Integer validType;

    @JsonProperty("expire_time")
    private String expireTime;
}