package com.baijiayun.openapi.sdk.dto.playback;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class ReplacePlaybackReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] type 类型 1:替换 2:新增
     */
    private Integer type;

    /**
     * [必填] source_room_id 源回放 room_id
     */
    @JsonProperty("source_room_id")
    private String sourceRoomId;

    /**
     * 源回放 session_id （长期教室传）
     */
    @JsonProperty("source_session_id")
    private String sourceSessionId;

    /**
     * [必填] target_room_id 目标回放 room_id
     */
    @JsonProperty("target_room_id")
    private String targetRoomId;

    /**
     * 目标回放 session_id （长期教室传）
     */
    @JsonProperty("target_session_id")
    private String targetSessionId;

    /**
     * 源回放版本
     */
    @JsonProperty("source_version")
    private Integer sourceVersion;

    /**
     * 是否替换成主版本 0:否 1:是
     */
    @JsonProperty("is_replace_main")
    private Integer isReplaceMain;

    /**
     * 目标回放版本
     */
    @JsonProperty("target_version")
    private Integer targetVersion;
}