package com.baijiayun.openapi.sdk.dto.playback;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetPushRecordErrorLogReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] product_type 1:大班课 2小班课
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;

    /**
     * 教室号
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * date
     */
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date;

    private Integer page;

    @JsonProperty("page_size")
    private Integer pageSize;
}