package com.baijiayun.openapi.sdk.dto.playback;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class GetPlayCountRankReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] start_date 开始日期,格式如(2021-09-07)
     */
    @JsonProperty("start_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date startDate;

    /**
     * [必填] end_date 结束日期,格式如(2021-09-07)
     */
    @JsonProperty("end_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date endDate;

    /**
     * 1:教育直播，2，小班课，3：双师，4，企业直播
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;
}