package com.baijiayun.openapi.sdk.dto.playback;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class GetListReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] page 页码，从1开始
     */
    private Integer page;

    /**
     * [必填] page_size 每一页返回的条数，不得超过1000
     */
    @JsonProperty("page_size")
    private Integer pageSize;

    /**
     * 是否返回 裁剪视频的回放，0：否；1：是
     */
    @JsonProperty("crop_video")
    private Integer cropVideo;

    /**
     * 教室id
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * [必填] product_type 1:教育直播，2，小班课，3：双师，4，企业直播
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;

    private String name;

    @JsonProperty("category_id")
    private Integer categoryId;
}