package com.baijiayun.openapi.sdk.dto.playback;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class GetCropListReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 1:教育直播，2，小班课，3：双师，4，企业直播
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;

    /**
     * [必填] room_id 教室号
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * 序列号（默认0，长期房间必须传此值）
     */
    @JsonProperty("session_id")
    private String sessionId;

    /**
     * 页码，从1开始，默认值是1
     */
    private Integer page;

    /**
     * 每页获取的记录条数，默认100，最大值不能超过1000
     */
    @JsonProperty("page_size")
    private Integer pageSize;
}