package com.baijiayun.openapi.sdk.dto.playback;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class DeletePlaybackChatReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] room_id 房间ID
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * 课节ID
     */
    @JsonProperty("session_id")
    private String sessionId;

    /**
     * 版本
     */
    private Integer version;

    /**
     * 删除开始时间，与删除结束时间同时传递
     */
    @JsonProperty("delete_start_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date deleteStartTime;

    /**
     * 删除结束时间，与删除开始时间同时传递
     */
    @JsonProperty("delete_end_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date deleteEndTime;

    /**
     * 删除指定用户user_number，与删除时间必须传递其一
     */
    @JsonProperty("delete_user_number")
    private String deleteUserNumber;
}