package com.baijiayun.openapi.sdk.dto.notice;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;

@Data
public class GetRollNoticeListReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * 页码
     */
    private Integer page;

    /**
     * 页面大小
     */
    @JsonProperty("page_size")
    private Integer pageSize;

    /**
     * 房间号
     */
    @JsonProperty("room_id")
    private String roomId;

    /**
     * 产品线类型 (1：大班课 2：小班课)
     * @see com.baijiayun.openapi.sdk.enums.BjyProductType
     */
    @JsonProperty("product_type")
    private Integer productType;
}