package com.baijiayun.openapi.sdk.dto.newsub;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class UpdateSubAccountReq implements Serializable {
    private static final long serialVersionUID = -1L;

    /**
     * [必填] sub_partner_id 子账号partner_id
     */
    @JsonProperty("sub_partner_id")
    private String subPartnerId;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 密码
     */
    private String password;

    /**
     * 联系人
     */
    private String contacts;

    /**
     * 公司
     */
    private String company;

    /**
     * 账号生效时间
     */
    @JsonProperty("effect_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectTime;

    /**
     * 账号失效时间
     */
    @JsonProperty("expire_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date expireTime;
}