package com.baijiayun.openapi.sdk.dto.newsub;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2024/7/10
 */
@Data
public class GetSubAccountListDto implements Serializable {
    /**
     * 公司名
     */
    private String company;

    /**
     * 合作者id
     */
    @JsonProperty("partner_id")
    private String partnerId;

    /**
     * 邮箱
     */
    private String email;

    /**
     * 手机号
     */
    private String mobile;

    /**
     * 联系人
     */
    private String contacts;

    /**
     * 账号生效时间
     */
    @JsonProperty("effect_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date effectTime;

    /**
     * 账号失效时间
     */
    @JsonProperty("expire_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date expireTime;

    /**
     * 账号状态
     */
    @JsonProperty("product_status")
    private GetSubAccountStatusDto productStatus;
}
